<!DOCTYPE html>
<html lang=\"en\">
<head>
    <meta charset=\"UTF-8\">
    <title>Admin – Black Car Service</title>
    <link rel=\"stylesheet\" href=\"assets/css/styles.css\">
</head>
<body class=\"admin-body\">
<div class=\"admin-layout-full\">
    <aside class=\"sidebar\">
        <div class=\"sidebar-header\">
            <h2>Admin</h2>
            <p>Black Car Service</p>
        </div>
        <nav>
            <button data-view=\"dashboard\" class=\"nav-item active\">Dashboard</button>
            <button data-view=\"bookings\" class=\"nav-item\">Bookings</button>
            <button data-view=\"fleet\" class=\"nav-item\">Fleet</button>
            <button data-view=\"drivers\" class=\"nav-item\">Drivers</button>
            <button data-view=\"promo\" class=\"nav-item\">Promo Codes</button>
            <button data-view=\"backup\" class=\"nav-item\">Backup</button>
        </nav>
    </aside>

    <main class=\"admin-main\">
        <!-- DASHBOARD -->
        <section id=\"view-dashboard\" class=\"admin-view active\">
            <h1>Dashboard</h1>
            <div class=\"cards\">
                <div class=\"card\">
                    <h3>Today&apos;s Bookings</h3>
                    <p id=\"stat-today\">0</p>
                </div>
                <div class=\"card\">
                    <h3>Upcoming Rides</h3>
                    <p id=\"stat-upcoming\">0</p>
                </div>
                <div class=\"card\">
                    <h3>Total Bookings</h3>
                    <p id=\"stat-total\">0</p>
                </div>
                <div class=\"card\">
                    <h3>Estimated Revenue</h3>
                    <p id=\"stat-revenue\">$0.00</p>
                </div>
            </div>
        </section>

        <!-- BOOKINGS -->
        <section id=\"view-bookings\" class=\"admin-view\">
            <h1>Bookings</h1>
            <div class=\"toolbar\">
                <input type=\"text\" id=\"bookingSearch\" placeholder=\"Search by name, location, vehicle...\">
                <select id=\"bookingStatusFilter\">
                    <option value=\"\">All Statuses</option>
                    <option value=\"pending\">Pending</option>
                    <option value=\"confirmed\">Confirmed</option>
                    <option value=\"completed\">Completed</option>
                    <option value=\"cancelled\">Cancelled</option>
                </select>
            </div>
            <table class=\"table\" id=\"bookingsTable\">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Created</th>
                    <th>Pickup</th>
                    <th>Dropoff</th>
                    <th>Date/Time</th>
                    <th>Vehicle</th>
                    <th>Customer</th>
                    <th>Status</th>
                    <th>Total</th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </section>

        <!-- FLEET -->
        <section id=\"view-fleet\" class=\"admin-view\">
            <h1>Fleet</h1>
            <button id=\"addVehicleBtn\" class=\"btn-secondary\">Add Vehicle</button>
            <table class=\"table\" id=\"fleetTable\">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Type</th>
                    <th>Max Pax</th>
                    <th>Max Luggage</th>
                    <th>Base Price</th>
                    <th>Price/Mile</th>
                    <th>Active</th>
                    <th></th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
            <button id=\"saveFleetBtn\" class=\"btn-primary\">Save Fleet</button>
            <div id=\"fleetMessage\" class=\"message\"></div>
        </section>

        <!-- DRIVERS -->
        <section id=\"view-drivers\" class=\"admin-view\">
            <h1>Drivers</h1>
            <button id=\"addDriverBtn\" class=\"btn-secondary\">Add Driver</button>
            <table class=\"table\" id=\"driversTable\">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Phone</th>
                    <th>Email</th>
                    <th>Active</th>
                    <th></th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
            <button id=\"saveDriversBtn\" class=\"btn-primary\">Save Drivers</button>
            <div id=\"driversMessage\" class=\"message\"></div>
        </section>

        <!-- PROMO CODES -->
        <section id=\"view-promo\" class=\"admin-view\">
            <h1>Promo Codes</h1>
            <p>Promo codes are read from <code>data/promo_codes.json</code>. Editing UI can be added later, but the codes are already active for pricing.</p>
            <table class=\"table\" id=\"promoTable\">
                <thead>
                <tr>
                    <th>Code</th>
                    <th>Type</th>
                    <th>Value</th>
                    <th>Description</th>
                    <th>Active</th>
                </tr>
                </thead>
                <tbody></tbody>
            </table>
        </section>

        <!-- BACKUP -->
        <section id=\"view-backup\" class=\"admin-view\">
            <h1>Backup</h1>
            <p>Download a ZIP backup of all JSON data files.</p>
            <a href=\"../api/backup.php\" class=\"btn-primary\">Download Backup</a>
        </section>
    </main>
</div>

<script src=\"assets/js/app.js\"></script>
</body>
</html>
