<?php
// Very simple JSON backup: zips /data and streams to browser
$root = realpath(__DIR__ . '/..');
$dataDir = $root . '/data';
$tmpZip = $root . '/backup-' . date('Ymd-His') . '.zip';

$zip = new ZipArchive();
if ($zip->open($tmpZip, ZipArchive::CREATE) === TRUE) {
    $files = scandir($dataDir);
    foreach ($files as $f) {
        if ($f === '.' || $f === '..') continue;
        $zip->addFile($dataDir . '/' . $f, 'data/' . $f);
    }
    $zip->close();

    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="backup-json.zip"');
    header('Content-Length: ' . filesize($tmpZip));
    readfile($tmpZip);
    unlink($tmpZip);
    exit;
} else {
    echo "Could not create backup.";
}
