<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$fleetFile = __DIR__ . '/../data/fleet.json';

function read_json_f($file) {
    if (!file_exists($file)) return [];
    $data = file_get_contents($file);
    $json = json_decode($data, true);
    return $json ?: [];
}

function write_json_f($file, $data) {
    $json = json_encode($data, JSON_PRETTY_PRINT);
    file_put_contents($file, $json);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    echo json_encode(read_json_f($fleetFile));
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if (!is_array($input)) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid JSON']);
        exit;
    }
    write_json_f($fleetFile, $input);
    echo json_encode(['success' => true]);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
