<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type");
header("Access-Control-Allow-Methods: GET, OPTIONS");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$promoFile = __DIR__ . '/../data/promo_codes.json';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    if (!file_exists($promoFile)) {
        echo json_encode([]);
        exit;
    }
    $data = file_get_contents($promoFile);
    $json = json_decode($data, true);
    echo json_encode($json ?: []);
    exit;
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
