<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$uploadDir = __DIR__ . "/../public/uploads/";
if (!file_exists($uploadDir)) mkdir($uploadDir, 0777, true);

if (!isset($_FILES['file'])) {
    echo json_encode(['success' => false, 'error' => 'No file']);
    exit;
}

$filename = time() . "_" . basename($_FILES['file']['name']);
$target = $uploadDir . $filename;

if (move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
    echo json_encode(['success' => true, 'url' => 'uploads/' . $filename]);
} else {
    echo json_encode(['success' => false, 'error' => 'Upload failed']);
}
