<?php
// Customer booking form
?>
<!DOCTYPE html>
<html lang=\"en\">
<head>
    <meta charset=\"UTF-8\">
    <title>Black Car Service – Booking</title>
    <link rel=\"stylesheet\" href=\"assets/css/styles.css\">
</head>
<body>
<header class=\"top-bar\">
    <h1>New Reservation</h1>
</header>

<main class=\"container\">
    <div class=\"steps\">
        <div class=\"step active\" data-step=\"1\">Step 1: Ride Info</div>
        <div class=\"step\" data-step=\"2\">Step 2: Select Vehicle</div>
        <div class=\"step\" data-step=\"3\">Step 3: Final Details</div>
    </div>

    <!-- STEP 1 -->
    <section id=\"step-1\" class=\"step-panel active\">
        <h2>Ride Info</h2>

        <div class=\"form-row\">
            <label>Select Service Type</label>
            <select id=\"serviceType\"></select>
        </div>

        <div class=\"form-row two-col\">
            <div>
                <label>Pick-Up Date</label>
                <input type=\"date\" id=\"pickupDate\">
            </div>
            <div>
                <label>Pick-Up Time</label>
                <input type=\"time\" id=\"pickupTime\">
            </div>
        </div>

        <div class=\"form-row\">
            <label>Pick-Up Location</label>
            <input type=\"text\" id=\"pickupLocation\" placeholder=\"Enter pickup address\">
        </div>

        <div class=\"form-row\">
            <label>Drop-Off Location</label>
            <input type=\"text\" id=\"dropoffLocation\" placeholder=\"Enter drop-off address\">
        </div>

        <div class=\"form-row two-col\">
            <div>
                <label>Number of Passengers</label>
                <input type=\"number\" id=\"passengers\" min=\"1\" value=\"1\">
            </div>
            <div>
                <label>Luggage Count</label>
                <input type=\"number\" id=\"luggage\" min=\"0\" value=\"0\">
            </div>
        </div>

        <div class=\"form-row\">
            <label>Child Seats</label>
            <div class=\"inline-group\">
                <select id=\"childSeatType\">
                    <option value=\"\">-- Select type --</option>
                    <option value=\"infant\">Rear Facing Seat (Infant)</option>
                    <option value=\"toddler\">Forward Facing Seat (Toddler)</option>
                    <option value=\"booster\">Booster Seat</option>
                </select>
                <input type=\"number\" id=\"childSeatQty\" min=\"1\" value=\"1\">
                <button type=\"button\" id=\"addChildSeatBtn\" class=\"btn-secondary\">Add</button>
            </div>
        </div>

        <ul id=\"childSeatList\" class=\"pill-list\"></ul>

        <div class=\"form-row\">
            <label>Estimated Distance (miles)</label>
            <input type=\"number\" id=\"distanceMiles\" min=\"0\" step=\"0.1\" placeholder=\"e.g. 15.2\">
            <small>You can enter the distance manually for now. Later this can be automated with Google Maps.</small>
        </div>

        <div class=\"form-row\">
            <label>Promo Code</label>
            <div class=\"inline-group\">
                <input type=\"text\" id=\"promoCode\" placeholder=\"Enter promo code\">
                <button type=\"button\" id=\"applyPromoBtn\" class=\"btn-secondary\">Apply</button>
            </div>
            <div id=\"promoMessage\" class=\"message\"></div>
        </div>

        <div class=\"form-row actions\">
            <button id=\"toStep2\" class=\"btn-primary\">Continue to Select Vehicle</button>
        </div>
    </section>

    <!-- STEP 2 -->
    <section id=\"step-2\" class=\"step-panel\">
        <h2>Select Vehicle</h2>
        <div id=\"vehicleList\" class=\"vehicle-grid\"></div>

        <div class=\"form-row actions\">
            <button class=\"btn-secondary\" data-prev=\"1\">Back</button>
            <button class=\"btn-primary\" id=\"toStep3\" disabled>Continue to Final Details</button>
        </div>
    </section>

    <!-- STEP 3 -->
    <section id=\"step-3\" class=\"step-panel\">
        <h2>Final Details</h2>

        <div class=\"summary-box\" id=\"bookingSummary\"></div>

        <div class=\"alert\">
            <strong>Payment method:</strong> Pay on pickup. No card is charged online.
        </div>

        <div class=\"form-row two-col\">
            <div>
                <label>First Name</label>
                <input type=\"text\" id=\"firstName\">
            </div>
            <div>
                <label>Last Name</label>
                <input type=\"text\" id=\"lastName\">
            </div>
        </div>

        <div class=\"form-row two-col\">
            <div>
                <label>Email</label>
                <input type=\"email\" id=\"email\">
            </div>
            <div>
                <label>Phone</label>
                <input type=\"tel\" id=\"phone\">
            </div>
        </div>

        <div class=\"form-row actions\">
            <button class=\"btn-secondary\" data-prev=\"2\">Back</button>
            <button class=\"btn-primary\" id=\"submitBooking\">Book Now</button>
        </div>

        <div id=\"bookingMessage\" class=\"message\"></div>
    </section>
</main>

<script src=\"assets/js/app.js\"></script>
</body>
</html>
